/*
 * QrfeEM4325Tag.h
 *
 *  Created on: 08.10.2013
 *      Author: stefan.detter
 */

#ifndef QRFENXPTAG_H_
#define QRFENXPTAG_H_

#include "../QrfeGen2Tag.h"
#include "../../QrfeGen2AdvancedManipulatorInterface.h"

class QrfeNXPTag : public QrfeGen2Tag
{
public:
    QrfeNXPTag(QString tagId, QrfeGen2AdvancedManipulatorInterface* reader, QObject* parent = 0);
    virtual ~QrfeNXPTag();

    QrfeGlobal::TMIResult nxp_setReadProtect ( QByteArray passwd );
    QrfeGlobal::TMIResult nxp_resetReadProtect ( QByteArray passwd );

    QrfeGlobal::TMIResult nxp_sendCmdToCtrler ( uchar cmd, QByteArray cmdData );

    QrfeGlobal::TMIResult nxp_readConfigWord ( QByteArray passwd, ushort &word );
    QrfeGlobal::TMIResult nxp_writeConfigWord ( QByteArray passwd, ushort word );

    QrfeGlobal::TMIResult nxp_readDownloadRegister ( QByteArray passwd, ushort &word );
    QrfeGlobal::TMIResult nxp_writeDownloadRegister ( QByteArray passwd, ushort word );
};

#endif /* QRFENXPTAG_H_ */
